package editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class MiniColorCanvas extends JPanel {
	private Image nothingImage;
	private JList listComponent;
	private DefaultListModel listModel;
	
	private Color singleColor;
	
	public MiniColorCanvas(JList theList, DefaultListModel theModel) {
		
		super();
		
		listComponent = theList;
		listModel = theModel;
		
		Border border = BorderFactory.createLineBorder(new Color(0,0,0));
		
		this.setBorder(border);
		
		this.setPreferredSize(new Dimension(25, 40));
		this.setMinimumSize(new Dimension(25, 40));
		this.setMaximumSize(new Dimension(25, 40));
		
		ImageIcon tempIcon = new ImageIcon(ColorCanvas.class.getResource("/images/no_bg_color.GIF"));
		
		if(tempIcon != null) {
			nothingImage = tempIcon.getImage();
		} else {
//			System.out.println("Agh!  The image is null!");
		}
		
		refresh();
		
	}
	
	public void paintComponent(Graphics g) {
		
		if(listComponent != null && listComponent.getSelectedIndex() >= 0) {
			
			ListedCustomImage li = (ListedCustomImage) listModel.get(listComponent.getSelectedIndex());
			
			Color currentPreviewColor = li.getTransparentColor();
			
			Color origColor = g.getColor();
			
			g.setColor(new Color(200, 200, 200));
			g.fillRect(0, 0, this.getWidth(), this.getHeight());
			
			if(currentPreviewColor != null) {
				g.setColor(currentPreviewColor);
				g.fillRect(5, 5, 51, 29);
				g.setColor(origColor);
			} else {
				g.drawImage(nothingImage, 5, 5, 51, 29, null);
			}
			
			g.setColor(origColor);
			
		} else if(singleColor != null) {
			
			Color origColor = g.getColor();
			
			g.setColor(new Color(200, 200, 200));
			g.fillRect(0, 0, this.getWidth(), this.getHeight());
			g.setColor(singleColor);
			g.fillRect(5, 5, 51, 29);
			g.setColor(origColor);
			
		} else {
			g.drawImage(nothingImage, 5, 5, 51, 29, null);
		}
		
	}
	
	public void refresh() {
		this.repaint();
	}
	
	public void setSingleColor(Color col) {
		singleColor = col;
	}
	
	public Color getSingleColor() {
		return singleColor;
	}
}
